var OSMPLightbox = (function(){
    var obj = {};

        obj.ie8 = {
        forceRepaint: function(elem){
            elem.addClass('z').removeClass('z');
        }
    }

// *********************************************************************************************** //
// *** FOCUS HANDLING **************************************************************************** //
// *********************************************************************************************** //

    obj.state = {
        modalOpen: false,
        modal: null,
        lastFocus: null,
        isMobile: $('body').attr('isMobile') === 'true'?true:false
    }

// *********************************************************************************************** //
// *** ELEMENTS ********************************************************************************** //
// *********************************************************************************************** //

    obj.elements = {
        'overlay': $('[control="overlay"]'),
        'lightboxes': $('[control="lightbox"]'),
        'lightboxesClose': $('[control="lightbox"]').find('.close'),
        'triggers': $('[lightbox-for]'),
        'mainContent': $('#main'),
        'header': $('[control="header"]'),
        'footer': $('[control="footer"]')
    }

// *********************************************************************************************** //
// *** ELEMENT EVENTS **************************************************************************** //
// *********************************************************************************************** //

    obj.events = {
        'triggers': {
            'click': function(e){
                var trigger = $(this);
                var overlay = obj.elements.overlay;
                var lightbox = obj.elements.lightboxes.filter('#' + trigger.attr('lightbox-for'));
                var closeButton = lightbox.find('.close a');
                obj.state.modal = lightbox.find('.container');

                var buttonOffset = trigger.offset();
                var contentOffset = $('.content').offset();

                if(!obj.state.isMobile) {
                    if (lightbox.hasClass('lightboxRight')) {
                        lightbox.css({
                            top: buttonOffset.top - contentOffset.top - lightbox.outerHeight(true) - 13,
                            left: buttonOffset.left - contentOffset.left - lightbox.outerWidth(true) + 11
                        })
                    } else if (lightbox.hasClass('lightboxLeft')){
                        lightbox.css({
                            top: buttonOffset.top - contentOffset.top - lightbox.outerHeight(true) - 13,
                            left: buttonOffset.left - contentOffset.left - 22
                        })
                    }
                }

                obj.state.lastFocus = trigger;
                obj.state.modalOpen = true;

                if(!(lightbox.hasClass('lightboxRight') || lightbox.hasClass('lightboxLeft')) || obj.state.isMobile){
                    $('html, body').css({
                        'overflow': 'hidden',
                        'position': 'relative',
                        'height': '100%'
                    });
                }

                overlay.fadeIn(200);
                lightbox.fadeIn(200, function(){
                    closeButton.focus();
                    obj.elements.mainContent.attr('aria-hidden', 'true');
                    obj.elements.header.attr('aria-hidden', 'true');
                    obj.elements.footer.attr('aria-hidden', 'true');
                });
            },
            'keypress': function(e){
                var self = $(this);
                if(e.which === 13 || e.which === 32) {
                    self.trigger('click');
                }
            }
        },
        'lightboxesClose': {
            'click': function(e){
                var self = $(this);
                obj.state.modalOpen = false;

                self.parent().parent().fadeOut(200, function(){

                    obj.elements.mainContent.attr('aria-hidden', 'false');
                    obj.elements.header.attr('aria-hidden', 'false');
                    obj.elements.footer.attr('aria-hidden', 'false');

                    if(!($(this).hasClass('lightboxLeft') || $(this).hasClass('lightboxRight')) || obj.state.isMobile){
                        $('html, body').css({
                            'overflow': '',
                            'position': '',
                            'height': ''
                        });
                        window.scrollTo(0, obj.state.lastFocus.offset().top);
                        obj.state.lastFocus.focus();
                    }
                });
                obj.elements.overlay.fadeOut(200);
            },
            'keypress': function(e){
                var self = $(this);
                if(e.which === 13 || e.which === 32) {
                    self.trigger('click');
                }
            }
        },
        'document': {
            'focus': function(e){
                if(obj.state.modalOpen && !obj.state.modal[0].contains(e.target)){
                    e.stopPropagation();
                    obj.state.modal.find('.close a').focus();
                }
            }
        }
    }


// *********************************************************************************************** //
// *** METHODS *********************************************************************************** //
// *********************************************************************************************** //

    obj.methods = {}

// *********************************************************************************************** //
// *** EVENT LISTENERS *************************************************************************** //
// *********************************************************************************************** //

    obj.elements.lightboxesClose.on('click', obj.events.lightboxesClose.click)
                                .on('keypress', obj.events.lightboxesClose.keypress);
    obj.elements.triggers.on('click', obj.events.triggers.click)
                         .on('keypress', obj.events.triggers.keypress);
    $(document).on('focus','[tabindex], input, a', obj.events.document.focus);

// *********************************************************************************************** //
// *** INITIAL SETUP ***************************************************************************** //
// *********************************************************************************************** //

    obj.init = function(e){

    }

// *********************************************************************************************** //
// *********************************************************************************************** //
// *********************************************************************************************** //

    return obj;
})();
